<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // 1) Soft deletes on transactions (if not yet present)
        if (!Schema::hasColumn('transactions', 'deleted_at')) {
            Schema::table('transactions', function (Blueprint $table) {
                $table->softDeletes()->after('updated_at');
            });
        }

        // 2) Deleted sales audit table
        if (!Schema::hasTable('sales_deletions')) {
            Schema::create('sales_deletions', function (Blueprint $table) {
                $table->bigIncrements('id');

                // Link back to original transaction
                $table->unsignedBigInteger('transaction_id')->index();

                // Common sale fields for quick filtering
                $table->string('invoice_no')->nullable()->index();
                $table->unsignedBigInteger('contact_id')->nullable()->index();
                $table->string('contact_name', 255)->nullable();
                $table->unsignedBigInteger('business_location_id')->nullable()->index();

                $table->decimal('final_total', 22, 4)->default(0);
                $table->string('payment_status', 50)->nullable();

                // Who deleted
                $table->unsignedBigInteger('deleted_by')->nullable()->index();

                // When
                $table->timestamp('deleted_at')->index();

                // Full JSON snapshot of the transaction + lines
                $table->json('payload')->nullable();

                $table->timestamps();

                // (optional) foreign keys if you want
                // $table->foreign('transaction_id')->references('id')->on('transactions')->cascadeOnDelete();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('sales_deletions')) {
            Schema::dropIfExists('sales_deletions');
        }
        if (Schema::hasColumn('transactions', 'deleted_at')) {
            Schema::table('transactions', function (Blueprint $table) {
                $table->dropSoftDeletes();
            });
        }
    }
};
